<?php
/**
 * System文章管理模型
 */
class System_Model extends Model {
	
	public function __construct() {
		parent::__construct();
	}	

	public function search($where, $limit = '0, 10', $order = 'id', $by = 'DESC') {
		if (!isset($where['status'])) {
			$where['status'] = 1;
		}
		if ($where['status'] < 0) {
			unset($where['status']);	
		}
		$res = $this->db->table('#@_system')
					->field('id, oid, status, name, eng_name, stitle, skeywords, sdescription, content')->where($where)
					->limit($limit)
					->order($order.' '.$by)
					->getAll();
		foreach ($res as &$value) {
			$value = $this->getVo($value);	
		}
		unset($value);
		return $res;
	}

	public function getList() {
		$cacheKey = 'system_list';
		if ($cacheData = $this->cache->getFromBox($cacheKey)) {
			return $cacheData;	
		}
		if ($cacheData = $this->cache->getFromFile($cacheKey)) {
			return $cacheData;	
		}
		$res = $this->db->table('#@_system')->order('oid, id ASC')->getAll('id');
		foreach ($res as &$value) {
			$value = $this->getVo($value);
		}
		unset($value);
		$this->cache->setToFile($cacheKey, $res);
		$this->cache->setToBox($cacheKey, $res);
		return $res;	
	}
		
	public function getVo($value) {
		$value['url'] = $this->getUrl($value);
		return $value;
	}
	
	public function del($id) {
		$modArticle = load_model('Article');
		$where = array(
			'id' => $id,
			'status' => -1
		);
		$list = $modArticle->search($where);
		foreach ($list as $value) {
			$modArticle->del($value['id']);	
		}
		$this->db->table('#@_system')->where("id = $id")->delete();
	}
	
	public function getUrl($systemInfo, $page = 0) {
		$id = $systemInfo['id'];
		$system = $this->getOne($id);
		$eng_name = $system['eng_name'];
		if (Wee::$config['url_html_system']) {
			$url = Wee::$config['web_url'] . $this->_getName($systemInfo, $page);
		} else {
			if (Wee::$config['url_mode'] > '0' && $eng_name !='') {
				$url = Wee::$config['web_url'] . $eng_name . Wee::$config['url_suffix'];
			} else {
				$url = url('System', '', array('id' => $id));	
			}
		}
		return $url;
	}
	
	public function getPath($systemInfo, $page = 0) {
		return APP_PATH . $this->_getName($systemInfo, $page);
	}
	
	private function _getName($systemInfo, $page = 0) {
		$engName = $systemInfo['eng_name'];
		if (!$engName) {
			$engName = 'd' . $systemInfo['id'];	
		}
		$name = "$engName";
		if (Wee::$config['url_dir_cate']) {
			$name = Wee::$config['url_dir_cate'] . '/system/' . $name;
		} 
		return $name . Wee::$config['url_suffix'];	
	}
		
	public function getOne($id) {
		$rs = $this->db->table('#@_system')
					->where("id = $id")
					->getOne();
		return $rs;	
	}
	
	public function getId($eng_name) {
		$rs = $this->db->table('#@_system')
					->where("eng_name = '$eng_name'")
					->getOne();
		return $rs['id'];	
	}
	
	public function set($id, $data) {
		$this->db->table('#@_system')->where("id = $id")->update($data);
	}

	public function getPlace($id) {
		$systemList = $this->getList();
		if (!isset($systemList[$id])) {
			return false;	
		}
		$systemInfo = $systemList[$id];
		return $systemInfo;
	}
}